define([
		'app',
		'VarUtilityAuthorizationService',
        'VarUtilityErrorService',
		'FormattedEmptyStringToNullValue',
		'RequiredNonZeroValue',
		'FormatStopCodes',
		'MovePrimaryCareToTop',
		'Capitalize',
       	'FilterSubmittedRequestLimit',
		'UnauthorizedController',
		'VarUtilityController',
		'DirectSchedulingController',
		'RequestsController',
		'CustomMessagesController',
		'ChangeLocationModalController',
		'InstitutionChoiceController',
		'InstitutionsService',
		'VarUtilitySecondaryNavigationController'
	],
	function (app) {
		'use strict';

		var AUTHORIZED_STATE = 'main.auth.two-panel.secondary-navigation.var-utility';

		var resolveAuthorization = function ($q, $timeout, pageService, mhpuser, VarUtilityAuthorizationService, VarUtilityErrorService) {
			var defer = $q.defer();

			mhpuser.fetch().then(function(result){
				VarUtilityAuthorizationService.checkAuthorizedKey().then(function(isAuthorized) {
					if(isAuthorized) {
						defer.resolve();
					} else {
						defer.reject({error: 'var-utility.unauthorized'});
					}
				}, function(errorResponse) {
					defer.reject({error: 'var-utility.unauthorized'});
				});
			}, function(error) {
				defer.reject();
			});

			return defer.promise;
		};

		app.config(function ($stateProvider, $urlRouterProvider) {
			$stateProvider
				.state(AUTHORIZED_STATE, {
					url: '/var-utility',
					appNavIndex: 2,
					data: {
						homeName: 'VA Tool Set Home',
						moduleName: 'VAR Utility',
						panel: 'secondary',
						secondaryPanelTitle: 'Manage Settings',
						secondaryPanelWidth: 'narrow',
						baseStateName : AUTHORIZED_STATE,
						paramSections : [
							{
								paramValue : 'direct-scheduling',
								sectionState: 'direct-scheduling',
								sectionName : 'Direct Scheduling',
								sectionIndex : 1
							},
							{
								paramValue : 'requests',
								sectionState: 'requests',
								sectionName : 'Requests',
								sectionIndex : 2
							},
							{
								paramValue : "custom-messages",
								sectionState: 'custom-messages',
								sectionName : "Custom Text",
								sectionIndex : 3
							}
						],
						headerButton : {
							text: "Change Location",
							buttonClass: "btn"
						}
					},
					resolve: {
						// NOTE: for Var Utility only, ensures mhpuser has been fetched in router instead of in localResourceDirectoryService
						authorization: resolveAuthorization,
						InstitutionsService: function(InstitutionsService) {
							return InstitutionsService;
						},
						activeInstitution: function(InstitutionsService,$state) {
							var institution = InstitutionsService.getActiveInstitution();
							if( institution ){
								return institution;
							} else {
								$state.go('main.auth.one-panel.var-utility.institution');
							}
						}
					},
					views: {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/var-utility/pages/var-utility-placeholder_template.html',
							controller: 'VarUtilityController'
						},
						'secondary@main.auth.two-panel': {
							templateUrl: 'src/modules/var-utility/pages/secondary-navigation/secondary-navigation-var-utility_template.html',
							controller: 'VarUtilitySecondaryNavigationController'
						}
					}
				})
				.state('main.auth.one-panel.var-utility', {
					abstract: true,
					resolve: {
						authorization: resolveAuthorization
					}
				})
				.state('main.auth.one-panel.var-utility.institution', {
					url: '/var-utility/institution',
					params: {
						moduleName: 'VAR Utility',
						primaryHeaderTitle: "Select Facility Location"
					},
					views: {
						'primary@main.auth.one-panel': {
							templateUrl: 'src/modules/var-utility/pages/institution-choice/institution_choice_template.html',
							controller: 'InstitutionChoiceController',
							resolve: {
								InstitutionsService: function(InstitutionsService) {
									return InstitutionsService;
								}
							}
						}
					}
				})
				.state(AUTHORIZED_STATE + '.direct-scheduling', {
					url: '/{section:direct-scheduling}',
					data: {
						panel : 'primary',
						backState : '^'
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/var-utility/pages/direct-scheduling/direct-scheduling_template.html',
							controller: 'DirectSchedulingController'
						}
					}
				})
				.state(AUTHORIZED_STATE + '.requests', {
					url: '/{section:requests}',
					data: {
						panel : 'primary',
						backState : '^'
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/var-utility/pages/requests/requests_template.html',
							controller: 'RequestsController'
						}

					}
				})
				.state(AUTHORIZED_STATE + '.custom-messages', {
					url: '/{section:custom-messages}',
					data: {
						panel : "primary",
						backState : '^'
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/var-utility/pages/custom-messages/custom-messages_template.html',
							controller: 'CustomMessagesController'
						}
					}
				});
		});
	}
);
